/*

Copyright (c) 2004 PXI Project Team

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in the
Software without restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies
or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "variant.h"
#include <cstdio>
#include <cstring>
using namespace std;

variant::variant( const variant &v )
{
    if ( v.vtype )
    {
        vtype = true;
        longValue = v.longValue;
    }
    else
    {
        vtype = false;
        stringValue = v.stringValue;
    }
	chunkValue = NULL;
	dictValue = NULL;
	dirty = false;
}

variant::variant( const double &l )
{
    vtype = true;
    longValue = l;
	chunkValue = NULL;
	dictValue = NULL;
	dirty = false;
}

variant::variant( const string &s )
{
    vtype = false;
    stringValue = s;
	chunkValue = NULL;
	dictValue = NULL;
	dirty = false;
}


variant::~variant( void )
{
	if( chunkValue )
	{
		delete chunkValue;
	}
	if( dictValue )
	{
		delete dictValue;
	}
}

